**********************************************************************************
*
* 
* 'reg_event_DD_FTA.do'
* (formerly known as 'coef_plots.do')
*
* PREPARE COEFFICIENT PLTS FOR VARIABLES OF INTEREST AFTER TRADE DEAL
* 
*
* Created       on October  16th  2020
* Last modified on December 23rd 2020
*
*
**********************************************************************************


**********************************************************************************
* FOR LOG
cap log close                       
clear                             

log using "./log/reg_event.log.do", replace text

* FOR LOG
display "$S_TIME  $S_DATE"
**********************************************************************************

**********************************************************************************
set more off
cap prog drop _all

program define winsor
sum `1', d
gen win_`1' = `1'
replace win_`1'=r(p1) if `1'<r(p1) & `1'!=.
replace win_`1'=r(p99) if `1'>r(p99) &`1'!=. 
end

program define winsor2
	sum `1', d
	gen win2_`1' = 0
	replace win2_`1' = 1 if `1'>r(p1) & `1'<r(p99) & `1'!=.
end
**********************************************************************************


**********************************************************************************
use "../task_LR/output/LRbetas_daily_trade.dta", replace


**********************************************************************************
	* Defining panel
	set more off
	cap egen id = group(ISOPAIR)
	xtset id year

	egen iso_1_t = group(base year)
	egen iso_2_t = group(foreign year)

	* Defining trade variables
	cap drop log_trade log_trade_gdp log_export log_import
	gen log_trade = log(trade_gross)
	gen log_export = log(export)
	gen log_import = log(import)

	gen trade_share = (  trade_gross / gdp_o )*100
	gen key_partner = 0
	replace key_partner = 1 if trade_share > 1

	replace fx_vol = fx_vol*sqrt(252)
	
	*Defining EIA variables 
	sort id year
	* replace EIA = l.EIA if year > 2012

	gen CUMECU = 0
	replace CUMECU = 1 if EIA == 4 | EIA == 5 | EIA == 6
	gen FTA = 0
	replace FTA = 1 if EIA == 3 
	gen TWPTA = 0
	replace TWPTA = 1 if EIA == 2
	gen OWPTA = 0 
	replace OWPTA = 1 if EIA == 1

	cap drop emerging
	gen emerging = 0
	replace emerging = 1 if ///
		base == "BRL" | base == "CLP" | base == "CNY" | base == "COP" | base == "CZK" | base == "EGP" | /// 
		base == "GRD" | base == "HUF" | base == "INR" | base == "IDR" | base == "KRW" | base == "MYR" | ///
		base == "MXN" | base == "PEN" | base == "PHP" | base == "PLN" | base == "QAR" | base == "RUB" | ///
		base == "ZAR" | base == "THB" | base == "TWD" | base == "TRY" | base == "AED" 
**********************************************************************************	


**********************************************************************************
	label var log_import "Log Imports"
	
	label var distw "Distance"
	label var contig "Common border"
	label var comlang_off "Common language"
	label var comcol "Colonial Link"
	label var comleg_pretrans "Shared Legal"

	***** EVENT STUDY: CUMECU/FTA *******
		cap drop experiment
		gen experiment = FTA + CUMECU
		cap drop treat
		bys ISOPAIR: egen treat = max(experiment)

		cap drop change
		sort id year
		gen change = 0
		bys id: replace change = 1 if experiment > l.experiment 
		cap drop change_id
		bys id: egen change_id = max(change)

		* Identifying year of change:
		cap drop event_date
		gen aux = year if change == 1
		bys id: egen event_date = mean(aux)
		drop aux	
	*******************************	

	gen diff = year - event_date

	set more off
	cap drop f_* l_*
	forvalues i = 1/50 {
		gen f_`i' = 0
		replace f_`i' = 1 if diff == `i'
		label variable f_`i' "`i'"
		
		gen l_`i' = 0
		replace l_`i' = 1 if diff == -`i'
		label variable l_`i' "-`i'"
	}
**********************************************************************************


**********************************************************************************
***** WINSORIZE!! 
winsor log_import
winsor beta
winsor R2_y
winsor fx_vol
winsor var_adj
winsor unshared_cls1
winsor unshared_cls2

winsor2 log_import
winsor2 beta
winsor2 R2_y
winsor2 fx_vol
winsor2 var_adj
winsor2 unshared_cls1
winsor2 unshared_cls2
**********************************************************************************


**********************************************************************************
	/* 
	## IMPORTANT: Year of change (D0) is the reference (constant) in the regressions ## 
	gen f_0 = 0
	replace f_0 = 1 if diff == 0
	label variable f_0 "0"  
	*/
	
	local varlist log_import R2_y beta fx_vol var_adj unshared_cls1 unshared_cls2 win_log_import

	eststo clear
	foreach var in `varlist' {

		cap drop dep_var 
		gen dep_var = `var'
		cap drop d5_dep_var
		gen d5_dep_var = dep_var - l5.dep_var
		
		display dep_var

		eststo: reghdfe dep_var ///
		l_50 l_49 l_48 l_47 l_46 l_45 l_44 l_43 l_42 l_41 ///
		l_40 l_39 l_38 l_37 l_36 l_35 l_34 l_33 l_32 l_31 ///
		l_30 l_29 l_28 l_27 l_26 l_25 l_24 l_23 l_22 l_21 ///
		l_20 l_19 l_18 l_17 l_16 l_15 l_14 l_13 l_12 l_11 ///
		l_10 l_9 l_8 l_7 l_6 l_5 l_4 l_3 l_2 l_1 ///
		f_* ///
		change_id ///
		distw contig comlang_off comcol comleg_pretrans ///
		, absorb(iso_1_t iso_2_t) cluster(id) resid

		coefplot, drop(l_21 l_22 l_23 l_24 l_25 ///
					   l_26 l_27 l_28 l_29 l_30 ///
					   l_31 l_32 l_33 l_34 l_35 ///
					   l_36 l_37 l_38 l_39 l_40 ///
					   l_41 l_42 l_43 l_44 l_45 ///
					   l_46 l_47 l_48 l_49 l_50 /// 
					   f_21 f_22 f_23 f_24 f_25 ///
					   f_26 f_27 f_28 f_29 f_30 ///
					   f_31 f_32 f_33 f_34 f_35 ///
					   f_36 f_37 f_38 f_39 f_40 ///
					   f_41 f_42 f_43 f_44 f_45 ///
					   f_46 f_47 f_48 f_49 f_50 ///
					   change_id ///
					   distw contig comlang_off comcol comleg_pretrans _cons) ///
					   vertical yline(0) xline(20.5, lpattern(dash) lcolor(black)) ///
		xlabel(,labsize(vsmall)) 

		*local output = "./output/figures/plot_coef_gravity_"+"`var'.pdf"
		*graph export `output', replace
		
		* Exporting regression results to txt *
		local outputr = "./output/coef_for_plots/coef_for_plot_postest_gravity_"+"`var'"+".txt" 
		outreg2 using `outputr', drop(distw contig comlang_off comcol comleg_pretrans) ///
		replace sideway stats(coef se pval) e(N r2) dec(3) nocons nor2 noobs noaster noparen 	
	}
				
	* Exporting regression results to tex table *
	*local output = "./output/tables/DiD_table_gravity.tex"
	*esttab using `output', compress ///
	*se(%9.3f) b(%9.3f) scalars(r2 F) star(** 0.05 *** 0.001) label replace ///
	*mtitle("Log Import" "FX vol" "Adjusted FX vol" "R-squared" "Base Loadings" )
**********************************************************************************


**********************************************************************************
** RUN THE BILATERAL PAIR FIXED EFFECT REGRESSION
eststo clear

local varlist log_import R2_y beta fx_vol var_adj unshared_cls1 unshared_cls2 win_log_import
	foreach var in `varlist' {
		cap drop dep_var 
		gen dep_var = `var'
		cap drop d5_dep_var
		gen d5_dep_var = dep_var - l5.dep_var
		*** Regression with country-pair FE instead of gravity:
		display dep_var
		eststo: reghdfe ///
		dep_var ///
		l_50 l_49 l_48 l_47 l_46 l_45 l_44 l_43 l_42 l_41 ///
		l_40 l_39 l_38 l_37 l_36 l_35 l_34 l_33 l_32 l_31 ///
		l_30 l_29 l_28 l_27 l_26 l_25 l_24 l_23 l_22 l_21 ///
		l_20 l_19 l_18 l_17 l_16 l_15 l_14 l_13 l_12 l_11 ///
		l_10 l_9 l_8 l_7 l_6 l_5 l_4 l_3 l_2 l_1 ///
		f_* /// 
		distw contig comlang_off comcol comleg_pretrans, ///
		absorb(iso_1_t iso_2_t id) cluster(id) resid
	
		coefplot, drop(l_21 l_22 l_23 l_24 l_25 ///
					   l_26 l_27 l_28 l_29 l_30 ///
					   l_31 l_32 l_33 l_34 l_35 ///
					   l_36 l_37 l_38 l_39 l_40 ///
					   l_41 l_42 l_43 l_44 l_45 ///
					   l_46 l_47 l_48 l_49 l_50 ///
					   f_21 f_22 f_23 f_24 f_25 ///
					   f_26 f_27 f_28 f_29 f_30 ///
					   f_31 f_32 f_33 f_34 f_35 ///
					   f_36 f_37 f_38 f_39 f_40 ///
					   f_41 f_42 f_43 f_44 f_45 ///
					   f_46 f_47 f_48 f_49 f_50 ///
					   change_id ///
					   distw contig comlang_off comcol comleg_pretrans _cons) ///
					   vertical yline(0) xline(20.5, lpattern(dash) lcolor(black)) ///
		xlabel(,labsize(vsmall)) 		
		*recast(line) lwidth(*2) ciopts(recast(rline) lpattern(dash)) 
		
		*local output = "./output/figures/plot_coef_"+"`var'"+".pdf"
		*graph export `output', replace

		* Exporting regression results to txt *
		local outputr = "./output/coef_for_plots/coef_for_plot_postest_fe_"+"`var'"+".txt"
		outreg2 using `outputr', drop(change_id distw contig comlang_off comcol comleg_pretrans) ///
		replace sideway stats(coef se pval) e(N r2) dec(3) nocons nor2 noobs noaster noparen 	
	}


********************************************************************
* Exporting regression results to tex table *
*local output = "./output/tables/DiD_table_FE.tex"
*esttab using `output', compress ///
*se(%9.3f) b(%9.3f) scalars(r2 F) star(** 0.05 *** 0.001) label replace ///
*mtitle("Log Import" "FX vol" "Adjusted FX vol" "R-squared" "Base Loadings" )		
********************************************************************



**********************************************************************************
** RUN THE EMERGING / DEVELOPED COUNTRY SPLIT REGRESSIONS
local varlist log_import R2_y beta fx_vol var_adj unshared_cls1 unshared_cls2 win_log_import

eststo clear
foreach var in `varlist' {

	cap drop dep_var 
	gen dep_var = `var'
	cap drop d5_dep_var
	gen d5_dep_var = dep_var - l5.dep_var
		
	eststo: reghdfe dep_var ///
	l_50 l_49 l_48 l_47 l_46 l_45 l_44 l_43 l_42 l_41 ///
	l_40 l_39 l_38 l_37 l_36 l_35 l_34 l_33 l_32 l_31 ///
	l_30 l_29 l_28 l_27 l_26 l_25 l_24 l_23 l_22 l_21 ///
	l_20 l_19 l_18 l_17 l_16 l_15 l_14 l_13 l_12 l_11 ///
	l_10 l_9 l_8 l_7 l_6 l_5 l_4 l_3 l_2 l_1 ///
	f_* ///
	change_id ///
	distw contig comlang_off comcol comleg_pretrans ///
	if emerging == 1 ///
	, absorb(iso_1_t iso_2_t) cluster(id) resid

	coefplot, drop(l_21 l_22 l_23 l_24 l_25 l_26 l_27 l_28 l_29 l_30 ///
		    			   l_31 l_32 l_33 l_34 l_35 l_36 l_37 l_38 l_39 l_40 ///
					   l_41 l_42 l_43 l_44 l_45 ///
					   l_46 l_47 l_48 l_49 l_50 /// 
					   f_21 f_22 f_23 f_24 f_25 ///
					   f_26 f_27 f_28 f_29 f_30 ///
					   f_31 f_32 f_33 f_34 f_35 ///
					   f_36 f_37 f_38 f_39 f_40 ///
					   f_41 f_42 f_43 f_44 f_45 ///
					   f_46 f_47 f_48 f_49 f_50 ///
					   change_id ///
					   distw contig comlang_off comcol comleg_pretrans _cons) ///
					   vertical yline(0) xline(20.5, lpattern(dash) lcolor(black)) ///
		xlabel(,labsize(vsmall)) 

		*local output = "./output/figures/plot_coef_gravity_emerging_"+"`var'.pdf"
		*graph export `output', replace
		
		* Exporting regression results to txt *
		local outputr = "./output/coef_for_plots/coef_for_plot_postest_gravity_emerging_"+"`var'"+".txt" 
		outreg2 using `outputr', drop(distw contig comlang_off comcol comleg_pretrans) ///
		replace sideway stats(coef se pval) e(N r2) dec(3) nocons nor2 noobs noaster noparen 	
	}
				
	* Exporting regression results to tex table *
	*local output = "./output/tables/DiD_table_gravity_emerging.tex"
	*esttab using `output', compress ///
	*se(%9.3f) b(%9.3f) scalars(r2 F) star(** 0.05 *** 0.001) label replace ///
	*mtitle("Log Import" "FX vol" "Adjusted FX vol" "R-squared" "Base Loadings" )
**********************************************************************************


**********************************************************************************
** RUN THE EMERGING / DEVELOPED COUNTRY SPLIT REGRESSIONS
local varlist log_import R2_y beta fx_vol var_adj unshared_cls1 unshared_cls2 win_log_import

eststo clear
foreach var in `varlist' {

	cap drop dep_var 
	gen dep_var = `var'
	cap drop d5_dep_var
	gen d5_dep_var = dep_var - l5.dep_var
		
	eststo: reghdfe dep_var ///
	l_50 l_49 l_48 l_47 l_46 l_45 l_44 l_43 l_42 l_41 ///
	l_40 l_39 l_38 l_37 l_36 l_35 l_34 l_33 l_32 l_31 ///
	l_30 l_29 l_28 l_27 l_26 l_25 l_24 l_23 l_22 l_21 ///
	l_20 l_19 l_18 l_17 l_16 l_15 l_14 l_13 l_12 l_11 ///
	l_10 l_9 l_8 l_7 l_6 l_5 l_4 l_3 l_2 l_1 ///
	f_* ///
	change_id ///
	distw contig comlang_off comcol comleg_pretrans ///
	if emerging == 0 ///
	, absorb(iso_1_t iso_2_t) cluster(id) resid

	coefplot, drop(l_21 l_22 l_23 l_24 l_25 l_26 l_27 l_28 l_29 l_30 ///
		    			   l_31 l_32 l_33 l_34 l_35 l_36 l_37 l_38 l_39 l_40 ///
					       l_41 l_42 l_43 l_44 l_45 l_46 l_47 l_48 l_49 l_50 /// 
					       f_21 f_22 f_23 f_24 f_25 f_26 f_27 f_28 f_29 f_30 ///
					       f_31 f_32 f_33 f_34 f_35 f_36 f_37 f_38 f_39 f_40 ///
					       f_41 f_42 f_43 f_44 f_45 f_46 f_47 f_48 f_49 f_50 ///
	  change_id ///
	  distw contig comlang_off comcol comleg_pretrans _cons) ///
	  vertical yline(0) xline(20.5, lpattern(dash) lcolor(black)) ///
		xlabel(,labsize(vsmall)) 

		*local output = "./output/figures/plot_coef_gravity_developed_"+"`var'.pdf"
		*graph export `output', replace
		
		* Exporting regression results to txt *
		local outputr = "./output/coef_for_plots/coef_for_plot_postest_gravity_developed_"+"`var'"+".txt" 
		outreg2 using `outputr', drop(distw contig comlang_off comcol comleg_pretrans) ///
		replace sideway stats(coef se pval) e(N r2) dec(3) nocons nor2 noobs noaster noparen 	
	}
				
	* Exporting regression results to tex table *
	*local output = "./output/tables/DiD_table_gravity_developed.tex"
	*esttab using `output', compress ///
	*se(%9.3f) b(%9.3f) scalars(r2 F) star(** 0.05 *** 0.001) label replace ///
	*mtitle("Log Import" "FX vol" "Adjusted FX vol" "R-squared" "Base Loadings" )
**********************************************************************************


**********************************************************************************
* FOR LOG
display "$S_TIME  $S_DATE"

cap log close
**********************************************************************************


